<?php

require_once "../controladores/contratos.controlador.php";
require_once "../modelos/contratos.modelo.php";

class AjaxContratos{

	/*=============================================
	EDITAR ACTA
	=============================================*/

	public $idservicios;

	public function ajaxEditarContratos(){

		$item = "idservicios";
		$valor = $this->idservicios;

		$respuesta = ControladorContratos::ctrMostrarContratos($item, $valor);

		echo json_encode($respuesta);


	}

	public function ajaxMostrarCobros(){

		$item = "idservicios";
		$valor = $this->idservicios;

		$respuesta = ControladorContratos::ctrMostrarCobros($item, $valor);

		echo json_encode($respuesta);


	}

	public function ajaxEliminarServicio(){

		$item = "idservicios";
		$valor = $this->idservicios;

		$respuesta = ControladorContratos::ctrEliminarServicio($item, $valor);

		echo json_encode($respuesta);


	}
	public function ajaxServiciosBaja(){

		$item = "idservicios";
		$valor = $this->idservicios;

		$respuesta = ControladorContratos::ctrBajaServicio($item, $valor);

		echo json_encode($respuesta);


	}
	public function ajaxserviciosValida(){

		$item = "idservicios";
		$valor = $this->idservicios;

		$respuesta = ControladorContratos::ctrserviciosValida($item, $valor);

		echo json_encode($respuesta);


	}



	public function ajaxEditarServicio(){

		$item = "idservicios";
		$valor = $this->idservicios;

		$respuesta = ControladorContratos::ctrEditarServicio($item, $valor);

		echo json_encode($respuesta);


	}

	public function ajaxContarContratos(){
		$respuesta = ControladorContratos::ctrcontarContratos();
		echo json_encode($respuesta);
	}

	public function ajaxContarContratosDescripcion($fechas){
		$datos = json_decode($fechas);
		$fecha1 = $datos[0];
		$fecha2 = $datos[1];
		$respuesta = ControladorContratos::ctrcontarContratosDescripcion($fecha1,$fecha2);
		echo json_encode($respuesta);
	}

	public function ajaxObtenerCobrosDiariosPorZona(){
		try {
			$respuesta = ControladorContratos::ctrObtenerCobrosDiariosPorZona();
			echo $respuesta; // Ya viene como JSON del controlador
		} catch (Exception $e) {
			error_log("Error en ajaxObtenerCobrosDiariosPorZona: " . $e->getMessage());
			echo json_encode(['error' => 'Error al obtener cobros diarios']);
		}
	}

	public function ajaxObtenerAnalisisMensual(){
		try {
			$respuesta = ControladorContratos::ctrObtenerAnalisisMensual();
			echo $respuesta; // Ya viene como JSON del controlador
		} catch (Exception $e) {
			error_log("Error en ajaxObtenerAnalisisMensual: " . $e->getMessage());
			echo json_encode(['error' => 'Error al obtener análisis mensual']);
		}
	}

	public function ajaxObtenerCobrosAnualesPorMes(){
		try {
			$respuesta = ControladorContratos::ctrObtenerCobrosAnualesPorMes();
			echo $respuesta; // Ya viene como JSON del controlador
		} catch (Exception $e) {
			error_log("Error en ajaxObtenerCobrosAnualesPorMes: " . $e->getMessage());
			echo json_encode(['error' => 'Error al obtener cobros anuales']);
		}
	}

	public function ajaxObtenerRecaudacionPorMetodoPago(){
		try {
			$respuesta = ControladorContratos::ctrObtenerRecaudacionPorMetodoPago();
			echo $respuesta; // Ya viene como JSON del controlador
		} catch (Exception $e) {
			error_log("Error en ajaxObtenerRecaudacionPorMetodoPago: " . $e->getMessage());
			echo json_encode(['error' => 'Error al obtener recaudación por método']);
		}
	}

	public function ajaxObtenerIngresosPorZona(){
		try {
			$respuesta = ControladorContratos::ctrObtenerIngresosPorZona();
			echo $respuesta; // Ya viene como JSON del controlador
		} catch (Exception $e) {
			error_log("Error en ajaxObtenerIngresosPorZona: " . $e->getMessage());
			echo json_encode(['error' => 'Error al obtener datos por zona']);
		}
	}




}


/*=============================================
EDITAR ACTA
=============================================*/

if(isset($_POST["idservicios"])){

	$persona = new AjaxActasNacimiento();
	$persona -> idPersona = $_POST["idservicios"];
	$persona -> ajaxEditarActaNacimientos();

}

if(isset($_POST["idserviciosCobro"])){

	$persona = new AjaxContratos();
	$persona -> idservicios = $_POST["idserviciosCobro"];
	$persona -> ajaxMostrarCobros();

}

if(isset($_POST["idserviciosEliminar"])){

	$persona = new AjaxContratos();
	$persona -> idservicios = $_POST["idserviciosEliminar"];
	$persona -> ajaxEliminarServicio();

}

if(isset($_POST["idserviciosBaja"])){

	$persona = new AjaxContratos();
	$persona -> idservicios = $_POST["idserviciosBaja"];
	$persona -> ajaxServiciosBaja();

}

if(isset($_POST["idserviciosValida"])){

	$persona = new AjaxContratos();
	$persona -> idservicios = $_POST["idserviciosValida"];
	$persona -> ajaxserviciosValida();

}

if(isset($_POST["editarServicio"])){

	$persona = new AjaxContratos();
	$persona -> idservicios = $_POST["editarServicio"];
	$persona -> ajaxEditarServicio();

}

if(isset($_POST["reporte-vencidos"])){
	session_start();
	$_SESSION['arrayFiltro'] = json_decode($_POST["reporte-vencidos"], true);
}

if(isset($_POST["contarcontratos"])){
	$contrato = new AjaxContratos();
	$contrato->ajaxContarContratos();
}

if(isset($_POST["totalservicio"])){
	$contrato = new AjaxContratos();
	$contrato->ajaxContarContratosDescripcion($_POST["totalservicio"]);
}

if(isset($_POST["cobrosdiarios"])){
	$contrato = new AjaxContratos();
	$contrato->ajaxObtenerCobrosDiariosPorZona();
}

if(isset($_POST["analisis-mensual"])){
	$contrato = new AjaxContratos();
	$contrato->ajaxObtenerAnalisisMensual();
}

if(isset($_POST["cobros-anuales"])){
	$contrato = new AjaxContratos();
	$contrato->ajaxObtenerCobrosAnualesPorMes();
}

if(isset($_POST["recaudacion-metodo"])){
	$contrato = new AjaxContratos();
	$contrato->ajaxObtenerRecaudacionPorMetodoPago();
}

if(isset($_POST["ingresosporzona"])){
	try {
		$contrato = new AjaxContratos();
		$contrato->ajaxObtenerIngresosPorZona();
	} catch (Exception $e) {
		// Datos de respaldo si hay error
		$datosEjemplo = [
			[
				'nombre_zona' => 'Zona 1',
				'idzona' => 1,
				'total_personas' => 25,
				'total_ingresos' => 1125000
			],
			[
				'nombre_zona' => 'Zona 2', 
				'idzona' => 15,
				'total_personas' => 18,
				'total_ingresos' => 810000
			],
			[
				'nombre_zona' => 'Zona 3',
				'idzona' => 16,
				'total_personas' => 12,
				'total_ingresos' => 540000
			],
			[
				'nombre_zona' => 'Zona 4',
				'idzona' => 17,
				'total_personas' => 8,
				'total_ingresos' => 360000
			]
		];
		echo json_encode($datosEjemplo);
	}
}
